import os
import sys
from shellcolor import shellcolor
import datetime
import subprocess
import conf
import subprocess
import multiprocessing
import dataparse
import vhost
import phpfpm
import time
import templates
import udatafile
import cpanel
import shutil
import pwd
import modsecurityrules
from multiprocessing.pool import ThreadPool


def install_deps():
    command="yum -y install zlib-devel pcre-devel openssl-devel GeoIP-devel yara-devel flex-devel bison-devel"
    subprocess.call(command,shell=True)
def cpnginx_version():
    vfile="/etc/cpnginx/version"
    if os.path.exists(vfile):
        ver=open(vfile,'r')
        version=ver.read().strip()
        return version
    else:
        version="unknown"
        return version

def install_modsecurityrules(setopt):
    insflag=False
    rmflag=False
    vflad=False
    for opt in setopt:
        if "install" == opt:
            insflag=True
        elif "remove" == opt:
            rmflag=True
        elif "owasp" == opt:
            vflad=True
            vendor="owasp"
    if insflag and vflad:
        modsecurityrules.install_rule(vendor)
    elif rmflag and vflad:
        modsecurityrules.remove_rule(vendor)
    elif not vflad:
        print ("Unsupported vendor. Currently nginxctl only support owasp rule set")

def setup_nginx_conf():
    nginx_conf="/etc/cpnginx/build/templates/nginx.conf"
    if os.path.exists("/etc/cpnginx/build/templates/custom/nginx.conf"):
        nginx_conf="/etc/cpnginx/build/templates/custom/nginx.conf"
    print(("Installing nginx configuration file from .. " + nginx_conf))
    subprocess.call(["rm -f /usr/local/nginx/conf/nginx.conf"],shell=True)
    copyconf='cp -vf '+nginx_conf + " /usr/local/nginx/conf/nginx.conf"
    subprocess.call(copyconf,shell=True)
    if not  os.path.exists("/usr/local/nginx/conf/conf.d/"):
        print ("conf.d not exist ")
        copyconfd='cp -vrf /etc/cpnginx/build/templates/conf.d /usr/local/nginx/conf/'
        subprocess.call(copyconfd,shell=True)
    else:
        copyconfd='cp -vrf /etc/cpnginx/build/templates/conf.d/* /usr/local/nginx/conf/conf.d/'
        subprocess.call(copyconfd,shell=True)
    if not os.path.exists('/usr/local/nginx/conf/vhost.d/'): 
       print ("Creating Virtual Host Configuration Directory .. /usr/local/nginx/conf/vhost.d/")
       subprocess.call(['mkdir -pv /usr/local/nginx/conf/vhost.d/'],shell=True)
    if not os.path.exists('/usr/local/nginx/conf/vhost.ssl.d/'): 
       print ("Creating Virtual Host SSL  Configuration Directory .. /usr/local/nginx/conf/vhost.ssl.d/")
       subprocess.call(['mkdir -pv /usr/local/nginx/conf/vhost.ssl.d/'],shell=True)
    if not os.path.exists('/usr/local/nginx/conf/ssl.cert.d/'): 
       print ("Creating  SSL  Certificate  Directory .. /usr/local/nginx/conf/ssl.cert.d/")
       subprocess.call(['mkdir -pv /usr/local/nginx/conf/ssl.cert.d/'],shell=True)
    if not os.path.exists('/usr/local/nginx/conf/ssl.ca.d/'): 
       print ("Creating  SSL  CA File  Directory .. /usr/local/nginx/conf/ssl.ca.d/")
       subprocess.call(['mkdir -pv /usr/local/nginx/conf/ssl.ca.d/'],shell=True)
    if not os.path.exists('/usr/local/nginx/conf/ssl.key.d/'): 
       print ("Creating  SSL  Key  Directory .. /usr/local/nginx/conf/ssl.key.d/")
       subprocess.call(['mkdir -pv /usr/local/nginx/conf/ssl.key.d/'],shell=True)

def setup_nginx_startup():
    if os.path.exists('/lib/systemd/system'):
        print ("Installing nginx systemd service ")
        subprocess.call(['cp -f /etc/cpnginx/build/templates/nginx.service /lib/systemd/system/'],shell=True)
        subprocess.call(['systemctl enable nginx.service'],shell=True)
        subprocess.call(['systemctl daemon-reload'],shell=True)
    else:
        print ("Installing nginx init script")
        subprocess.call(['cp -f /etc/cpnginx/build/templates/nginx.rc /etc/init.d/nginx'],shell=True)
        subprocess.call(['chmod 0755 /etc/init.d/nginx'],shell=True)
        subprocess.call(['chkconfig --add nginx'],shell=True)
        subprocess.call(['chkconfig nginx on'],shell=True)

def setup_nginx_chkservd():
    if os.path.exists('/etc/chkserv.d/nginx'):
        print(("Nginx Chkservd Configuration file  already exists .. " + shellcolor.green+"ok"+shellcolor.end))
    else:
        copycmd='cp -f /etc/cpnginx/build/templates/nginx.chkservd /etc/chkserv.d/nginx'
        subprocess.call(copycmd,shell=True)
        enablechk=['echo "nginx:1" >> /etc/chkserv.d/chkservd.conf ']   # need to add as new line 
        subprocess.call(enablechk,shell=True)
        changeapache=['sed -i s/80/9080/g /etc/chkserv.d/httpd']
        attr=['chattr +ia /etc/chkserv.d/httpd']
        subprocess.call(changeapache,shell=True)
        subprocess.call(attr,shell=True)
        subprocess.call(['/usr/local/cpanel/scripts/restartsrv_chkservd'],shell=True)
        print(("nginx chkservd installed  .. /etc/chkserv.d/nginx .." + shellcolor.green+"ok"+shellcolor.end))
        
def change_apache_port():
    dfile="/etc/cpnginx/data/settings.json"
    http_port=dataparse.readjsonval(dfile,"APACHE_HTTP_PORT")[0]
    https_port=dataparse.readjsonval(dfile,"APACHE_HTTPS_PORT")[0]
    cmdhttp='sed -i s/apache_port.*/apache_port=0.0.0.0:'+http_port+'/g /var/cpanel/cpanel.config'
    cmdhttps='sed -i s/apache_ssl_port.*/apache_ssl_port=0.0.0.0:'+https_port+'/g /var/cpanel/cpanel.config'
 #   cmdhttp='sed -i s/apache_port.*/apache_port=0.0.0.0:9080/g /var/cpanel/cpanel.config'
 #   cmdhttps='sed -i s/apache_ssl_port.*/apache_ssl_port=0.0.0.0:9443/g /var/cpanel/cpanel.config'
    subprocess.call(cmdhttp,shell=True)
    subprocess.call(cmdhttps,shell=True)
    subprocess.call(['/usr/local/cpanel/scripts/rebuildhttpdconf'],shell=True)
    subprocess.call(['/usr/local/cpanel/scripts/restartsrv_httpd'],shell=True)

def restart_nginx():
    if os.path.exists('/lib/systemd/system'):
        subprocess.call(['systemctl restart nginx'],shell=True)
        subprocess.call(['systemctl status nginx'],shell=True)
    else:
        subprocess.call(['/etc/init.d/nginx restart'],shell=True)
def reload_nginx():
    subprocess.call(['/usr/local/nginx/sbin/nginx -s reload'],shell=True)
#-----------------------------Start  of Nginx Build -----------------------------------------#

def install_nginx(options):
    vflag=False
    ppseedflag=False
    modsecflag=False
    settings=dataparse.readjson('/etc/cpnginx/data/settings.json')
    if not options:
        version=conf.NGINXVERSION
        vflag=True
    else:
        for opt in options:
            if '--version=' in opt:
                version=opt.split('=')[1]
                vflag=True
            else:
                version=conf.NGINXVERSION
                vflag=True
        for opt in options:
            if '--enable-pagespeed' == opt:
                ppseedflag=True
            elif '--enable-modsec' == opt:
                modsecflag=True
    print(""".........................................................
                    Cpnginx Custom Nginx Build 
..........................................................""")
    
    base='./configure --prefix=/usr/local/nginx --error-log-path=/var/log/cpnginx.error.log --pid-path=/run/cpnginx.pid --with-http_ssl_module --with-threads --with-http_v2_module --with-http_realip_module --with-http_stub_status_module'
    temps=' --http-client-body-temp-path=/var/cache/nginx/client_body_temp --http-proxy-temp-path=/var/cache/nginx/proxy_temp --http-fastcgi-temp-path=/var/cache/nginx/fastcgi_temp --http-uwsgi-temp-path=/var/cache/nginx/uwsgi_temp --http-scgi-temp-path=/var/cache/nginx/uwsgi_temp'
    withpagespeed='--add-module=/opt/cpnginx/nginx_pagespeed '
    withmodsec='--add-module=/opt/cpnginx/modsecurity-nginx '
    lodconf='/etc/cpnginx/build/configure.sh'
    extra=' '
    if os.path.exists('/etc/cpnginx/build/custom/configure.sh'):
        lodconf='/etc/cpnginx/build/custom/configure.sh'
    with open(lodconf, 'r') as read_obj: 
        for line in read_obj:
            if ( (';' not in line) and ( '#' not in line )  and (not line == '\n')):
                extra+=line.strip()+' '
    configure=base+temps+extra
    spath='/opt/cpnginx'
    pspeepath=spath+'/nginx_pagespeed'
    msecpath=spath+'/modsecurity'
    src=spath+'/src'
    if not os.path.exists(src):
        os.makedirs(src)
    if (ppseedflag):
        if not os.path.exists(pspeepath):
            os.makedirs(pspeepath)
        configure=configure+withpagespeed
    if(modsecflag):
        if not os.path.exists(msecpath):
            os.makedirs(msecpath)
        configure=configure+withmodsec
    #print(version,vflag,ppseedflag,modsecflag)
    pagespeedurl='https://files.syslint.com/src/nginx/nginx_pagespeed.latest.tar.gz'
    modsecurityurl='https://files.syslint.com/src/nginx/modsecurity.latest.tar.gz'
    modsec_Nginx='https://files.syslint.com/src/nginx/modsecurity-nginx.tar.gz'
    install_deps()
    '''Setup page speed source for compilation '''
    if (ppseedflag):
        print('Google Page Speed Module Build option enabled  ... '+shellcolor.green+"downloading source"+shellcolor.end)
        if os.path.exists(pspeepath):
            print ("Removing old pagespeed source from .. "+pspeepath)
            try:
                shutil.rmtree(pspeepath)
                os.makedirs(pspeepath)
            except OSError as e:
                print("Error: %s : %s" % (pspeepath, e.strerror))
                pass
        download_pagespeed='curl -# '+pagespeedurl+' -o '+src+'/nginx_pagespeed.latest.tar.gz'
        subprocess.call(download_pagespeed,shell=True)
        print ('Extracting nginx module source files in  ' +src+'/nginx_pagespeed.latest.tar.gz  please wait ...')
        pspeed_extract='tar -xzf '+src+'/nginx_pagespeed.latest.tar.gz -C '+spath
        subprocess.call(pspeed_extract,shell=True)
        print (shellcolor.green+"done"+shellcolor.end)
    '''Setup modsecurity  source '''
    if(modsecflag):
        print('ModSecurity  Module Build option enabled  ... '+shellcolor.green+"downloading source"+shellcolor.end)
        if os.path.exists(msecpath):
            try:
                shutil.rmtree(msecpath)
                os.makedirs(msecpath)
            except OSError as e:
                print("Error: %s : %s" % (msecpath, e.strerror))
                pass
        download_modsecurity='curl -# '+modsecurityurl+' -o '+src+'/modsecurity.latest.tar.gz'
        subprocess.call(download_modsecurity,shell=True)
        print ('Extracting ModSecurity  source files in  ' +src+' /modsecurity.latest.tar.gz please wait ...')
        if os.path.exists(src+'/modsecurity'):
            shutil.rmtree(src+'/modsecurity')
        modsec_extract='tar -xzf '+src+'/modsecurity.latest.tar.gz -C '+src
        subprocess.call(modsec_extract,shell=True)
        print (shellcolor.green+"done"+shellcolor.end)
        os.chdir(src+'/modsecurity')
        print ('Building modsecurity and libmodsecurity for Nginx ')
        buildmsec='./build.sh && ./configure --prefix=/opt/cpnginx/modsecurity  && make -j'+str(os.cpu_count())+' && make install'
        print(buildmsec)
        subprocess.call(buildmsec,shell=True)
        with open('/etc/ld.so.conf.d/cpnginxmodsec.conf', 'w') as t:
            t.write('/opt/cpnginx/modsecurity/lib')
        subprocess.call('/usr/sbin/ldconfig',shell=True)
        if os.path.exists(src+'/modsecurity/unicode.mapping'):
           shutil.copy(src+'/modsecurity/unicode.mapping','/etc/cpnginx/build/templates/conf.d/unicode.mapping') 
        print("Downloading nginx modsecurity connector plugin .. "+shellcolor.green+"downloading source"+shellcolor.end)
        msecConnectorPath='/opt/cpnginx/modsecurity-nginx'
        if os.path.exists(msecConnectorPath):
            try:
                shutil.rmtree(msecConnectorPath)
                os.makedirs(msecConnectorPath)
            except OSError as e:
                print("Error: %s : %s" % (msecConnectorPath, e.strerror))
                pass
        download_msec_connector='curl -# '+modsec_Nginx+' -o '+src+'/modsecurity-nginx.tar.gz'
        subprocess.call(download_msec_connector,shell=True)
        print ('Extracting ModSecurity Nginix Connector  source files in  ' +spath+'/modsecurity-nginx  please wait ...')
        msec_conn_exac='tar -xzf '+src+'/modsecurity-nginx.tar.gz -C '+spath
        subprocess.call(msec_conn_exac,shell=True)
        npluginconf='/opt/cpnginx/modsecurity-nginx/config'
        if os.path.exists(npluginconf):
            with open(npluginconf,'r') as content:
                save=content.read()
            with open(npluginconf,'w') as content:
                content.write("MODSECURITY_INC=/opt/cpnginx/modsecurity/include\nMODSECURITY_LIB=/opt/cpnginx/modsecurity/lib \n")
            with open(npluginconf,'a') as content:
                content.write(save)
    ''' Installing Nginx'''
    cachedir='/var/cache/nginx'
    if not os.path.exists(cachedir):
       os.makedirs(cachedir) 
    uid=pwd.getpwnam('nobody').pw_uid
    gid=pwd.getpwnam('nobody').pw_gid
    os.chown(cachedir,uid,gid)
    nginx_sdir=src+'/nginx-'+version
    nginx_src=src+'/nginx-'+version+'.tar.gz'
    nginx_surl='https://nginx.org/download/nginx-'+version+'.tar.gz'
    if os.path.exists(nginx_sdir):
        shutil.rmtree(nginx_sdir)
    ndownload='curl -# '+nginx_surl+' -o '+nginx_src
    print('Downloading Nginx .. nginx-'+version+'.tar.gz'+shellcolor.green+" ... downloading"+shellcolor.end)
    subprocess.call(ndownload,shell=True)
    if not os.path.exists(nginx_src):
        print("Nginx Source Download faild")
        sys.exit(0)
    nextract='tar -xzf '+nginx_src+' -C '+src
    subprocess.call(nextract,shell=True)
    buildcmd=configure+' && make -j'+str(os.cpu_count())+' && make install'
    subprocess.call('ldconfig',shell=True)
    print('..............'+shellcolor.green)
    print(buildcmd)
    print(shellcolor.end)
    print('..............')
    os.chdir(nginx_sdir)
    subprocess.call(buildcmd,shell=True)
    if not os.path.exists('/usr/local/nginx/sbin/nginx'):
        print('Nginx Build'+shellcolor.red+'Failed'+shellcolor.end)
        sys.exit(0)
    if os.path.exists('/usr/local/nginx/logs'):
        try:
            shutil.rmtree('/usr/local/nginx/logs')
        except OSError as e:
            print("Error: %s : %s" % ('/usr/local/nginx/logs', e.strerror))
            pass
    if not os.path.exists('/usr/local/nginx/conf/conf.d'):
        os.makedirs('/usr/local/nginx/conf/conf.d')
    if not os.path.exists('/usr/local/nginx/conf/ssl.ca.d'):
        os.makedirs('/usr/local/nginx/conf/ssl.ca.d/')
    if not os.path.exists('/usr/local/nginx/conf/ssl.cert.d'):
        os.makedirs('/usr/local/nginx/conf/ssl.cert.d')
    if not os.path.exists('/usr/local/nginx/conf/ssl.key.d'):
        os.makedirs('/usr/local/nginx/conf/ssl.key.d')
    if not os.path.exists('/usr/local/nginx/conf/vhost.d'):
        os.makedirs('/usr/local/nginx/conf/vhost.d')
    if not os.path.exists('/usr/local/nginx/conf/vhost.ssl.d'):
        os.makedirs('/usr/local/nginx/conf/vhost.ssl.d')
    setup_nginx_conf()
    if (ppseedflag):
        settings['GOOGLE_PAGE_SPEED'][0]="1"
        if not os.path.exists("/usr/local/nginx/conf/conf.d/pagespeed.conf"):
            shutil.copy('/etc/cpnginx/build/templates/conf.d/pagespeed.conf','/usr/local/nginx/conf/conf.d/pagespeed.conf')
    else:
        settings['GOOGLE_PAGE_SPEED'][0]="0"
        if os.path.exists("/usr/local/nginx/conf/conf.d/pagespeed.conf"):
            os.remove('/usr/local/nginx/conf/conf.d/pagespeed.conf')
    if (modsecflag):
        settings['MOD_SECURITY'][0]="1"
        if not os.path.exists('/usr/local/nginx/conf/modsecurity.rules'):
            os.makedirs('/usr/local/nginx/conf/modsecurity.rules')
        if not os.path.exists("/usr/local/nginx/conf/conf.d/modsecurity.conf"):
            shutil.copy('/etc/cpnginx/build/templates/conf.d/modsecurity.conf','/usr/local/nginx/conf/conf.d/modsecurity.conf')
        if not os.path.exists("/usr/local/nginx/conf/modsecurity_rules.conf"):
            shutil.copy('/etc/cpnginx/build/templates/conf.d/modsecurity_rules.conf','/usr/local/nginx/conf/modsecurity_rules.conf')
        if os.path.exists('/etc/cpnginx/build/templates/conf.d/unicode.mapping'):
            shutil.copy('/etc/cpnginx/build/templates/conf.d/unicode.mapping','/usr/local/nginx/conf/unicode.mapping')
        if os.path.exists("/usr/local/nginx/conf/conf.d/modsecurity_rules.conf"):
            os.remove('/usr/local/nginx/conf/conf.d/modsecurity_rules.conf')
        if os.path.exists('/usr/local/nginx/conf/conf.d/unicode.mapping'):
            os.remove('/usr/local/nginx/conf/conf.d/unicode.mapping')
    else:
        settings['MOD_SECURITY'][0]="0"
        if os.path.exists("/usr/local/nginx/conf/conf.d/modsecurity.conf"):
            os.remove('/usr/local/nginx/conf/conf.d/modsecurity.conf')
        if os.path.exists("/usr/local/nginx/conf/conf.d/modsecurity_rules.conf"):
            os.remove('/usr/local/nginx/conf/conf.d/modsecurity_rules.conf')
        if os.path.exists('/usr/local/nginx/conf/unicode.mapping'):
            os.remove('/usr/local/nginx/conf/unicode.mapping')
        if os.path.exists('/usr/local/nginx/conf/conf.d/unicode.mapping'):
            os.remove('/usr/local/nginx/conf/conf.d/unicode.mapping')
        if os.path.exists('/usr/local/nginx/conf/modsecurity_rules.conf'):
            os.remove('/usr/local/nginx/conf/modsecurity_rules.conf')
    dataparse.writejson(settings,'/etc/cpnginx/data/settings.json')
    setup_nginx_startup()
    setup_nginx_chkservd()
    change_apache_port()
    print("Enabling Cpnginx Log Roation  ...",end =" ")
    loggertemplate='/etc/cpnginx/build/templates/logrotate.cpnginx'
    if os.path.exists(loggertemplate):
        shutil.copy(loggertemplate,'/etc/logrotate.d/cpnginx')
    print (shellcolor.green+"done"+shellcolor.end)
    restart_nginx()
    rebuild_all_vhost()
    print (shellcolor.yellow)
    subprocess.call(['/usr/local/nginx/sbin/nginx -V'],shell=True)
    print (shellcolor.end)
    restart_nginx()
    

'''End of nginx build  '''

def status():
    if os.path.exists('/lib/systemd/system'):
        cmdstatus='systemctl status nginx.service'
    else:
        cmdstatus='/etc/init.d/nginx status'
    subprocess.call(cmdstatus,shell=True)

def restart():
    print((shellcolor.yellow+"......... Restarting Nginx Web  Server ..... starting .."+shellcolor.end))
    restart_nginx()
    print((shellcolor.yellow+"......... Restarting Nginx Web  Server ..... finished .."+shellcolor.end))

def version():
    print(("Cpnginx  Version : " + cpnginx_version() ))
    nprocess = subprocess.run(['/usr/local/nginx/sbin/nginx -v'], shell=True,check=True,stdout=subprocess.PIPE)
    nginxversion=str(nprocess.stdout,'utf-8').strip()
    #nginxversion=subprocess.check_output(['/usr/local/nginx/sbin/nginx -v'],shell=True)
    aprocess = subprocess.run(["httpd -v | head -1  | awk '{ print $3 }'"], shell=True,check=True,stdout=subprocess.PIPE)
    apacheversion=str(aprocess.stdout,'utf-8')
    #apacheversion=subprocess.check_output(["httpd -v | head -1  | awk '{ print $3 }'"],shell=True)
    print(("Apache version : " + apacheversion))

def buildsslcerts():
    print ("Rebuilding all ssl certificate , key and ca-bulde files  ")
    vhost.build_all_ssl_certs()
    reload_nginx
    print((shellcolor.green+"DONE"+shellcolor.end))

def rebuild_all_vhost_mthread(userdata,ssldata,dedicate_ip,firewall,settings,domain):
    confpath='/usr/local/nginx/conf/vhost.d/'+domain+'.conf'
    havessl="0"
    if domain in dedicate_ip:
        havedip="1"
    else:
        havedip="0"
    vhostdata =  vhost.build_vhost(userdata[domain],havessl,havedip,firewall,settings,ssldata)
    fo=open(confpath,"w")
    fo.write(vhostdata)
    fo.close()
    vhostdata=""
    print(("Generating  nginx "+shellcolor.pink+"HTTP"+shellcolor.end+"  configuration file for " +shellcolor.green+ domain+shellcolor.end + " on ... " + shellcolor.yellow+confpath+shellcolor.end))
    if userdata[domain][2] == "addon" or userdata[domain][2] == "parked":
        sdomain=userdata[domain][3]
        if sdomain in ssldata:
            keycrt=ssldata[sdomain]['key']
            cert=ssldata[sdomain]['certificate']
            ca=ssldata[sdomain]['cabundle']
            ssldata[domain]={'key': keycrt,'certificate': cert,'cabundle': ca}
    #if domain in ssldomain:
    #if vhost.have_valid_ssl(domain):
    if domain in ssldata:
        havessl="1"
        confpath_ssl='/usr/local/nginx/conf/vhost.ssl.d/'+domain+'.conf'
        vhostdata_ssl =  vhost.build_vhost(userdata[domain],havessl,havedip,firewall,settings,ssldata)
        fo=open(confpath_ssl,"w")
        fo.write(vhostdata_ssl)
        fo.close()
        vhostdata_ssl=""
        print(("Generating  nginx "+shellcolor.green+"HTTPS"+shellcolor.end+"  configuration file for " +shellcolor.green+ domain+shellcolor.end + " on ... " + shellcolor.yellow+confpath_ssl+shellcolor.end))


def rebuild_all_vhost():
    userdata=dataparse.get_vhost_data()
    userdata.update(udatafile.get_vhost_data_from_file())
    ssldata=cpanel.get_all_ssl_certificates()
    #ssldomain=vhost.get_ssl_domains()
    dedicate_ip=vhost.get_dedicated_ip_domains()
    firewall=vhost.get_firewall()
    settings=vhost.get_default_settings()
    parallel=ThreadPool(os.cpu_count())
    for domain in userdata:
        if os.path.exists('/etc/cpnginx/disablemultiprocessing'):
            confpath='/usr/local/nginx/conf/vhost.d/'+domain+'.conf'
            havessl="0"
            if domain in dedicate_ip:
                havedip="1"
            else:
                havedip="0"
            vhostdata =  vhost.build_vhost(userdata[domain],havessl,havedip,firewall,settings,ssldata)
            fo=open(confpath,"w")
            fo.write(vhostdata)
            fo.close()
            vhostdata=""
            print(("Generating  nginx "+shellcolor.pink+"HTTP"+shellcolor.end+"  configuration file for " +shellcolor.green+ domain+shellcolor.end + " on ... " + shellcolor.yellow+confpath+shellcolor.end))
            if userdata[domain][2] == "addon" or userdata[domain][2] == "parked":
                sdomain=userdata[domain][3]
                if sdomain in ssldata:
                    keycrt=ssldata[sdomain]['key']
                    cert=ssldata[sdomain]['certificate']
                    ca=ssldata[sdomain]['cabundle']
                    ssldata[domain]={'key': keycrt,'certificate': cert,'cabundle': ca}
            #if domain in ssldomain:
            #if vhost.have_valid_ssl(domain):
            if domain in ssldata:
                havessl="1"
                confpath_ssl='/usr/local/nginx/conf/vhost.ssl.d/'+domain+'.conf'
                vhostdata_ssl =  vhost.build_vhost(userdata[domain],havessl,havedip,firewall,settings,ssldata)
                fo=open(confpath_ssl,"w")
                fo.write(vhostdata_ssl)
                fo.close()
                vhostdata_ssl=""
                print(("Generating  nginx "+shellcolor.green+"HTTPS"+shellcolor.end+"  configuration file for " +shellcolor.green+ domain+shellcolor.end + " on ... " + shellcolor.yellow+confpath_ssl+shellcolor.end))
        else:
            parallel.apply_async(rebuild_all_vhost_mthread,(userdata,ssldata,dedicate_ip,firewall,settings,domain))
    parallel.close()
    parallel.join()
            
    vhost.build_defaul_vhost()
    reload_nginx()

def rebuildvhost(domain):
    alluserdata=dataparse.get_vhost_data()
    firewall=vhost.get_firewall()
    settings=vhost.get_default_settings()
    userdata={}
    if domain in alluserdata:
        userdata[domain]=alluserdata[domain]
        domainvalid="1"
    else:
        domainvalid="0"
    if domainvalid == "0":
        alluserdata=udatafile.get_vhost_data_from_file()
        if domain in alluserdata:
            userdata[domain]=alluserdata[domain]
            domainvalid="1"
        else:
            domainvalid="0"
    if domainvalid == "1":
        #ssldomain=vhost.get_ssl_domains()
        ssldata=cpanel.get_all_ssl_certificates()
        dedicate_ip=vhost.get_dedicated_ip_domains()
        confpath='/usr/local/nginx/conf/vhost.d/'+domain+'.conf'
        havessl="0"
        if userdata[domain][2] == "addon" or userdata[domain][2] == "parked":
            sdomain=userdata[domain][3]
            if sdomain in ssldata:
                keycrt=ssldata[sdomain]['key']
                cert=ssldata[sdomain]['certificate']
                ca=ssldata[sdomain]['cabundle']
                ssldata[domain]={'key': keycrt,'certificate': cert,'cabundle': ca}
        if domain in dedicate_ip:
            havedip="1"
        else:
            havedip="0"
        vhostdata =  vhost.build_vhost(userdata[domain],havessl,havedip,firewall,settings,ssldata)
        fo=open(confpath,"w")
        fo.write(vhostdata)
        fo.close()
        vhostdata=""
        print(("Generating  nginx "+shellcolor.pink+"HTTP"+shellcolor.end+"  configuration file for " +shellcolor.green+ domain+shellcolor.end + " on ... " + shellcolor.yellow+confpath+shellcolor.end))
        #if domain in ssldomain:
        #if vhost.have_valid_ssl(domain):
        if domain in ssldata:
            havessl="1"
            confpath_ssl='/usr/local/nginx/conf/vhost.ssl.d/'+domain+'.conf'
            vhostdata_ssl =  vhost.build_vhost(userdata[domain],havessl,havedip,firewall,settings,ssldata)
            fo=open(confpath_ssl,"w")
            fo.write(vhostdata_ssl)
            fo.close()
            vhostdata_ssl=""
            print(("Generating  nginx "+shellcolor.green+"HTTPS"+shellcolor.end+"  configuration file for " +shellcolor.green+ domain+shellcolor.end + " on ... " + shellcolor.yellow+confpath_ssl+shellcolor.end))

    else:
        print(("Rebuilding vhost ..  "+ domain + shellcolor.fail +" ..  failed  ..  No such domain !!!"+shellcolor.end))
    reload_nginx()

def rebuilduservhost(cpuser):
    firewall=vhost.get_firewall()
    settings=vhost.get_default_settings()
    if os.path.exists("/var/cpanel/users/"+cpuser):
        print(("Rebuilding all domains nginx vhost configuration files for  user ..." +shellcolor.pink+cpuser+shellcolor.end))
        userdata=vhost.get_user_domains(cpuser)
        #ssldomain=vhost.get_ssl_domains()
        ssldata=cpanel.get_all_ssl_certificates()
        dedicate_ip=vhost.get_dedicated_ip_domains()
        for domain in userdata:
            #print userdata[domain]
            confpath='/usr/local/nginx/conf/vhost.d/'+domain+'.conf'
            havessl="0"
            if domain in dedicate_ip:
                havedip="1"
            else:
                havedip="0"
            vhostdata =  vhost.build_vhost(userdata[domain],havessl,havedip,firewall,settings,ssldata)
            fo=open(confpath,"w")
            fo.write(vhostdata)
            fo.close()
            vhostdata=""
            print(("Generating  nginx "+shellcolor.pink+"HTTP"+shellcolor.end+"  configuration file for " +shellcolor.green+ domain+shellcolor.end + " on ... " + shellcolor.yellow+confpath+shellcolor.end))
            #if domain in ssldomain:
            #if vhost.have_valid_ssl(domain):
            if domain in ssldata:
                havessl="1"
                confpath_ssl='/usr/local/nginx/conf/vhost.ssl.d/'+domain+'.conf'
                vhostdata_ssl =  vhost.build_vhost(userdata[domain],havessl,havedip,firewall,settings,ssldata)
                fo=open(confpath_ssl,"w")
                fo.write(vhostdata_ssl)
                fo.close()
                vhostdata_ssl=""
                print(("Generating  nginx "+shellcolor.green+"HTTPS"+shellcolor.end+"  configuration file for " +shellcolor.green+ domain+shellcolor.end + " on ... " + shellcolor.yellow+confpath_ssl+shellcolor.end))
    else:
        print(("No such cpanel user .. "+shellcolor.fail+"NOT FOUND"+shellcolor.end))
    reload_nginx()

def rmuservhost(cpuser):
    if not os.path.exists("/var/cpanel/users/"+cpuser):
        print(("Unknown user "+ cpuser))
        sys.exit()
    userdata=vhost.get_user_domains(cpuser)
    for domain  in userdata:
        vdom="/usr/local/nginx/conf/vhost.d/"+domain+".conf"
        vdomin="/usr/local/nginx/conf/vhost.d/"+domain+".include"
        vdomre="/usr/local/nginx/conf/vhost.d/"+domain+".rewrite"
        vdomssl="/usr/local/nginx/conf/vhost.ssl.d/"+domain+".conf"
        vdomsslin="/usr/local/nginx/conf/vhost.ssl.d/"+domain+".include"
        vdomsslre="/usr/local/nginx/conf/vhost.ssl.d/"+domain+".rewrite"
        ddata="/etc/cpnginx/domains/"+domain+".json"
        if os.path.exists(ddata):
            os.remove(ddata)
        if os.path.exists(vdom):
            os.remove(vdom)
            print(("Removed Nginx vhost configuration "+shellcolor.green+vdom+shellcolor.end))
        if os.path.exists(vdomin):
            os.remove(vdomin)
            print(("Removed Nginx vhost include "+shellcolor.green+vdomin+shellcolor.end))
        if os.path.exists(vdomre):
            os.remove(vdomre)
            print(("Removed Nginx vhost rewrite "+shellcolor.green+vdomre+shellcolor.end))
        if os.path.exists(vdomssl):
            sslcrt="/usr/local/nginx/conf/ssl.cert.d/"+domain+"_cert"
            sslkey="/usr/local/nginx/conf/ssl.key.d/"+domain+"_key"
            sslca="/usr/local/nginx/conf/ssl.ca.d/"+domain+"_ca-bundle"
            if os.path.exists(sslcrt):
                os.remove(sslcrt)
                print(("Removed ssl certificate "+shellcolor.green+sslcrt+shellcolor.end))
            if os.path.exists(sslkey):
                os.unlink(sslkey)
                print(("Removed ssl keyfile "+shellcolor.green+sslkey+shellcolor.end))
            if os.path.exists(sslca):
                os.unlink(sslca)
                print(("Removed ssl ca-bundle "+shellcolor.green+sslca+shellcolor.end))
            os.remove(vdomssl)
            print(("Removed Nginx ssl vhost  "+shellcolor.green+vdomssl+shellcolor.end))
        if os.path.exists(vdomsslin):
            os.remove(vdomsslin)
            print(("Removed Nginx ssl vhost include "+shellcolor.green+vdomsslin+shellcolor.end))
        if os.path.exists(vdomsslre):
            os.remove(vdomsslre)
            print(("Removed Nginx ssl vhost rewrite "+shellcolor.green+vdomsslre+shellcolor.end))
    phpfpm.clear_fpm_user(cpuser)
    fpmini='/etc/cpnginx/domains/'+cpuser+'.fpm.json'
    if os.path.exists(fpmini):
        os.unlink(fpmini)
        print("Removed user custom phpfpm INI ")
    subprocess.call(['/usr/local/nginx/sbin/nginx -s reload'],shell=True)
def rmvhost(domain):
    vdom="/usr/local/nginx/conf/vhost.d/"+domain+".conf"
    vdomin="/usr/local/nginx/conf/vhost.d/"+domain+".include"
    vdomre="/usr/local/nginx/conf/vhost.d/"+domain+".rewrite"
    vdomssl="/usr/local/nginx/conf/vhost.ssl.d/"+domain+".conf"
    vdomsslin="/usr/local/nginx/conf/vhost.ssl.d/"+domain+".include"
    vdomsslre="/usr/local/nginx/conf/vhost.ssl.d/"+domain+".rewrite"
    ddata="/etc/cpnginx/domains/"+domain+".json"
    if os.path.exists(ddata):
        os.remove(ddata)
    if os.path.exists(vdom):
        os.remove(vdom)
        print(("Removed Nginx vhost configuration "+shellcolor.green+vdom+shellcolor.end))
    if os.path.exists(vdomin):
        os.remove(vdomin)
        print(("Removed Nginx vhost include "+shellcolor.green+vdomin+shellcolor.end))
    if os.path.exists(vdomre):
        os.remove(vdomre)
        print(("Removed Nginx vhost rewrite "+shellcolor.green+vdomre+shellcolor.end))
    if os.path.exists(vdomssl):
        sslcrt="/usr/local/nginx/conf/ssl.cert.d/"+domain+"_cert"
        sslkey="/usr/local/nginx/conf/ssl.key.d/"+domain+"_key"
        sslca="/usr/local/nginx/conf/ssl.ca.d/"+domain+"_ca-bundle"
        if os.path.exists(sslcrt):
            os.remove(sslcrt)
            print(("Removed ssl certificate "+shellcolor.green+sslcrt+shellcolor.end))
        if os.path.exists(sslkey):
            os.unlink(sslkey)
            print(("Removed ssl keyfile "+shellcolor.green+sslkey+shellcolor.end))
        if os.path.exists(sslca):
            os.unlink(sslca)
            print(("Removed ssl ca-bundle "+shellcolor.green+sslca+shellcolor.end))
        os.remove(vdomssl)
        print(("Removed Nginx ssl vhost  "+shellcolor.green+vdomssl+shellcolor.end))
    if os.path.exists(vdomsslin):
        os.remove(vdomsslin)
        print(("Removed Nginx ssl vhost include "+shellcolor.green+vdomsslin+shellcolor.end))
    if os.path.exists(vdomsslre):
        os.remove(vdomsslre)
        print(("Removed Nginx ssl vhost rewrite "+shellcolor.green+vdomsslre+shellcolor.end))
    subprocess.call(['/usr/local/nginx/sbin/nginx -s reload'],shell=True)
def enable():
    if  os.path.exists("/etc/cpnginx/disablecpnginx"):
        changeapache=['sed -i s/80/9080/g /etc/chkserv.d/httpd']
        attr=['chattr +ia /etc/chkserv.d/httpd']
        subprocess.call(changeapache,shell=True)
        subprocess.call(attr,shell=True)
        #subprocess.call(['/usr/local/cpanel/scripts/cpnginx/hooks/cpnginxhooks install'],shell=True)
        setup_nginx_chkservd()
        change_apache_port()
        restart_nginx()
        os.remove('/etc/cpnginx/disablecpnginx')
        print((shellcolor.yellow+"See the default webserver status below"+shellcolor.end))
        subprocess.call(['netstat -pant | egrep nginx'],shell=True)
        subprocess.call(['netstat -pant | egrep httpd'],shell=True)
        print ("Cpginx has been enabled")
    else:
        print(("Cpnginx is already enabled  .. " + shellcolor.green +"done"+shellcolor.end))

def disable():
    if os.path.exists("/etc/cpnginx/disablecpnginx"):
        print(("Cpnginx is already disabled  .. " + shellcolor.green +"done"+shellcolor.end))
    else:
        cmdchk="grep -v nginx /etc/chkserv.d/chkservd.conf > /tmp/disable.nginx"
        cmdchkre="cat /tmp/disable.nginx > /etc/chkserv.d/chkservd.conf"
        attr=['chattr -ia /etc/chkserv.d/httpd']
        changeapache=['sed -i s/9080/80/g /etc/chkserv.d/httpd']
        cmdhttp='sed -i s/apache_port.*/apache_port=0.0.0.0:80/g /var/cpanel/cpanel.config'
        cmdhttps='sed -i s/apache_ssl_port.*/apache_ssl_port=0.0.0.0:443/g /var/cpanel/cpanel.config'
        subprocess.call(cmdhttp,shell=True)
        subprocess.call(cmdhttps,shell=True)
        subprocess.call(['/usr/local/cpanel/scripts/rebuildhttpdconf'],shell=True)
        if os.path.exists('/lib/systemd/system'):
            subprocess.call(['systemctl stop nginx'],shell=True)
        else:
            subprocess.call(['/etc/init.d/nginx stop'],shell=True)
        subprocess.call(cmdchk,shell=True)
        subprocess.call(cmdchkre,shell=True)
        subprocess.call(attr,shell=True)
        subprocess.call(changeapache,shell=True)
        subprocess.call(['rm -f /etc/chkserv.d/nginx'],shell=True)
        subprocess.call(['/usr/local/cpanel/scripts/restartsrv_chkservd'],shell=True)
        subprocess.call(['/usr/local/cpanel/scripts/restartsrv_httpd'],shell=True)
        #subprocess.call(['/usr/local/cpanel/scripts/cpnginx/hooks/cpnginxhooks remove'],shell=True)
        subprocess.call(['touch /etc/cpnginx/disablecpnginx'],shell=True)
        print((shellcolor.green+"Waiting 10 seconds for a clean apache start"+shellcolor.end))
        time.sleep(10)
        print((shellcolor.yellow+"See the default webserver status below"+shellcolor.end))
        subprocess.call(['netstat -pant | egrep httpd'],shell=True)
        subprocess.call(['netstat -pant | egrep nginx'],shell=True)
        
def setupphpfpm():
    fpmdb=phpfpm.ea4_default_php_fpm()  
    filename="/etc/cpnginx/data/fpm.json"
    dataparse.writejson(fpmdb,filename)
def templaterebuild():
    templates.build_templates()

def buildremoteip():
    command=['httpd -M | grep remoteip_module']
    DEVNULL = open(os.devnull, 'w')
    proc=subprocess.Popen(command,stdout=DEVNULL,stderr=DEVNULL,shell=True)
    (output, err) = proc.communicate()
    p_status = proc.wait()
    if p_status == 1:
        command1=['yum -y install ea-apache24-mod_remoteip']
        subprocess.call(command1,shell=True)
        print(("Installing  mod-remoteip for Apache .. "+ shellcolor.green + "starting" + shellcolor.end  ))
        command2=['/usr/local/cpanel/scripts/ipusage| awk \'{print $1}\'']
        #y=subprocess.check_output(command2,shell=True).split()
        process = subprocess.run(command2, shell=True,check=True,stdout=subprocess.PIPE)
        y=process.stdout.split()
        remoteip="RemoteIPHeader X-Real-IP\nRemoteIPInternalProxy 127.0.0.1\n"
        for i in y:
            remoteip += "RemoteIPInternalProxy " + str(i,'utf-8') +"\n"
        conf=open("/etc/apache2/conf.modules.d/361_mod_cpgninx.conf","w")
        conf.write(remoteip)
        conf.close()
        print(("Installing  mod-remoteip for Apache .. /etc/apache2/conf.modules.d/361_mod_cpgninx.conf .. "+ shellcolor.green + "done" + shellcolor.end))
        result ="ok"
    else:
        print(("Installing  mod-remoteip configurations for  Apache .. "+ shellcolor.green + "starting" + shellcolor.end  ))
        command2=['/usr/local/cpanel/scripts/ipusage| awk \'{print $1}\'']
        #y=subprocess.check_output(command2,shell=True).split()
        process = subprocess.run(command2, shell=True,check=True,stdout=subprocess.PIPE)
        y=process.stdout.split()
        remoteip="RemoteIPHeader X-Real-IP\nRemoteIPInternalProxy 127.0.0.1\n"
        for i in y:
            remoteip += "RemoteIPInternalProxy " + str(i,'utf-8') +"\n"
        conf=open("/etc/apache2/conf.modules.d/361_mod_cpgninx.conf","w")
        conf.write(remoteip)
        conf.close()
        print(("Installing  mod-remoteip configurations for  Apache .. /etc/apache2/conf.modules.d/361_mod_cpgninx.conf .. "+ shellcolor.green + "done" + shellcolor.end )) 
        result ="ok"
    sys.stdout.write( "Running Apache Domlog  Fix .. ")
    cmd="sed -i s/%h/%a/g /var/cpanel/templates/apache2_4/ea4_main.default"
    subprocess.call(cmd,shell=True)
    cmdap="/usr/local/cpanel/scripts/rebuildhttpdconf"
    result=subprocess.check_output(cmdap,shell=True)
    print((shellcolor.green+"done"+shellcolor.end))

    return  result

def cleanfpm():
    phpfpm.remove_all_fpm_user()




























