#!/opt/cppython/bin/python3 -B
"""
copyright(c) cpnginx.com
Hook for rebuilding domain vhosts
"""
import os
import sys
import json
import subprocess


def read_in():
    lines = sys.stdin.readlines()
    for i in range(len(lines)):
        lines[i] = lines[i].replace('\n','')
    return lines

def main():
    lines = read_in()
    data=lines[0]
    cpdata = json.loads(data)
    domain=cpdata['data']['args']['domain']
    sslvhost='/usr/local/nginx/conf/vhost.ssl.d/'+domain+'.conf'
    sslcert='/usr/local/nginx/conf/ssl.cert.d/'+domain+'_cert'
    sslkey='/usr/local/nginx/conf/ssl.key.d/'+domain+'_key'
    sslca='/usr/local/nginx/conf/ssl.ca.d/'+domain+'_ca-bundle'
    if os.path.exists(sslvhost):
        os.unlink(sslvhost)
    if os.path.exists(sslcert):
        os.unlink(sslcert)
    if os.path.exists(sslkey):
        os.unlink(sslkey)
    if os.path.exists(sslca):
        os.unlink(sslca)
    cmd="/usr/local/cpanel/scripts/nginxctl rebuildvhost "+domain
    process = subprocess.run(cmd, shell=True,check=True,stdout=subprocess.PIPE)
    out=process.stdout
    return(1)

if __name__ == "__main__":
    main()
